# MECASOS Backend API

RESTful API for the MECASOS roadside assistance application.

## Base URL
```
https://mecasos.numerexdigital.com/api
```

## Authentication
Most endpoints require authentication using JWT tokens. Include the token in the Authorization header:
```
Authorization: Bearer YOUR_JWT_TOKEN
```

## Endpoints

### Authentication

#### Register User
```
POST /api/auth/register
Content-Type: application/json

{
  "name": "John Doe",
  "email": "john@example.com",
  "password": "securePassword123",
  "phone": "+225 07 12 34 56 78",
  "userType": "client" // or "mechanic"
}

Response:
{
  "success": true,
  "message": "Registration successful",
  "data": {
    "user": {...},
    "token": "jwt_token_here"
  }
}
```

#### Login
```
POST /api/auth/login
Content-Type: application/json

{
  "email": "john@example.com",
  "password": "securePassword123"
}

Response:
{
  "success": true,
  "message": "Login successful",
  "data": {
    "user": {...},
    "token": "jwt_token_here"
  }
}
```

#### Logout
```
POST /api/auth/logout
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "message": "Logout successful"
}
```

#### Get Current User
```
GET /api/auth/me
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "user": {...}
  }
}
```

### Users

#### Get Users
```
GET /api/users?userType=mechanic&isOnline=1
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "users": [...]
  }
}
```

#### Get Nearby Mechanics
```
GET /api/users/nearby?latitude=5.3600&longitude=-4.0083&radius=50
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "mechanics": [
      {
        "id": "...",
        "name": "...",
        "distance": 2.5, // km
        "average_rating": 4.5,
        "total_reviews": 10
      }
    ]
  }
}
```

#### Update User
```
PUT /api/users/:id
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "name": "Updated Name",
  "phone": "+225 07 98 76 54 32",
  "isOnline": true
}
```

### Vehicles

#### Get Vehicles
```
GET /api/vehicles
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "vehicles": [...]
  }
}
```

#### Create Vehicle
```
POST /api/vehicles
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "brand": "Toyota",
  "model": "Corolla",
  "year": 2020,
  "plateNumber": "AB 1234 CI",
  "vehicleType": "car"
}
```

#### Update Vehicle
```
PUT /api/vehicles/:id
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "brand": "Honda",
  "model": "Civic"
}
```

#### Delete Vehicle
```
DELETE /api/vehicles/:id
Authorization: Bearer YOUR_TOKEN
```

### Breakdown Requests

#### Get Requests
```
GET /api/requests?status=pending
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "requests": [...]
  }
}
```

#### Create Request
```
POST /api/requests
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "vehicleId": "vehicle_id",
  "breakdownType": "battery",
  "description": "Car won't start",
  "latitude": 5.3600,
  "longitude": -4.0083,
  "address": "Abidjan, Cocody"
}
```

#### Accept Request (Mechanic)
```
PUT /api/requests/:id/accept
Authorization: Bearer YOUR_TOKEN
```

#### Update Request Status
```
PUT /api/requests/:id/status
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "status": "inProgress",
  "price": 15000 // optional, for completed status
}
```

#### Cancel Request
```
DELETE /api/requests/:id
Authorization: Bearer YOUR_TOKEN
```

### Reviews

#### Get Reviews
```
GET /api/reviews?mechanicId=mechanic_id
Authorization: Bearer YOUR_TOKEN
```

#### Create Review
```
POST /api/reviews
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "requestId": "request_id",
  "mechanicId": "mechanic_id",
  "rating": 5,
  "comment": "Excellent service!"
}
```

#### Update Review
```
PUT /api/reviews/:id
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "rating": 4,
  "comment": "Updated review"
}
```

#### Delete Review
```
DELETE /api/reviews/:id
Authorization: Bearer YOUR_TOKEN
```

### Wallet

#### Get Wallet Balance
```
GET /api/wallet
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "wallet": {
      "id": "...",
      "user_id": "...",
      "balance": 50000.00,
      "created_at": "...",
      "updated_at": "..."
    }
  }
}
```

#### Top Up Wallet
```
POST /api/wallet/topup
Authorization: Bearer YOUR_TOKEN
Content-Type: application/json

{
  "amount": 10000,
  "paymentMethod": "mixxByYas" // or "moovMoney", "card"
}

Response:
{
  "success": true,
  "message": "Wallet topped up successfully",
  "data": {
    "wallet": {...},
    "transaction": {
      "id": "...",
      "amount": 10000,
      "reference": "TOP-ABC123XYZ"
    }
  }
}
```

#### Get Transactions
```
GET /api/wallet/transactions?limit=50&offset=0
Authorization: Bearer YOUR_TOKEN

Response:
{
  "success": true,
  "data": {
    "transactions": [...]
  }
}
```

## Response Format

All responses follow this format:

### Success Response
```json
{
  "success": true,
  "message": "Operation successful",
  "data": {
    // Response data here
  }
}
```

### Error Response
```json
{
  "success": false,
  "message": "Error description",
  "error": "Detailed error message (optional)"
}
```

## HTTP Status Codes

- `200` - Success
- `201` - Created
- `400` - Bad Request
- `401` - Unauthorized
- `403` - Forbidden
- `404` - Not Found
- `409` - Conflict
- `500` - Internal Server Error

## Breakdown Types
- `battery`
- `tire`
- `fuelEmpty`
- `towing`
- `keyLost`
- `engineFailure`
- `brakeFailure`
- `electrical`
- `overheating`
- `starter`
- `transmission`
- `suspension`
- `lights`
- `other`

## Request Statuses
- `pending` - Waiting for mechanic
- `accepted` - Mechanic assigned
- `inProgress` - Mechanic on the way
- `completed` - Service completed
- `cancelled` - Request cancelled

## Payment Methods
- `mixxByYas`
- `moovMoney`
- `card`

## Setup Instructions

1. Upload all files to `mecasos.numerexdigital.com/api`
2. Import the database schema from `database_schema.md`
3. Update `config.php` with proper JWT secret
4. Ensure PHP version >= 7.4
5. Install PHPMailer: `composer require phpmailer/phpmailer`
6. Set proper file permissions (755 for directories, 644 for files)

## Dependencies

- PHP >= 7.4
- MySQL >= 5.7
- PDO Extension
- PHPMailer (for email functionality)

## Security Notes

1. Change the JWT_SECRET in config.php to a secure random string
2. Enable HTTPS in production
3. Update CORS settings to restrict allowed origins
4. Store sensitive credentials in environment variables
5. Implement rate limiting for production
