# Configuration pour Test Local - MECASOS Admin

## 🎯 Objectif
Ce document explique comment configurer le projet pour qu'il fonctionne en environnement local (localhost).

## ✅ Corrections apportées

### 1. **Détection automatique d'environnement**
- Le système détecte automatiquement si vous êtes en local ou en production
- URLs relatives utilisées automatiquement sur localhost
- URLs absolues maintenues pour la production

### 2. **Fichiers modifiés**
- `config/constants.php` : Détection automatique + URLs relatives
- `index.php` : Utilisation des constantes au lieu de liens absolus
- `includes/header.php` : Standardisation des includes
- `config/functions.php` : Avatar local (plus de dépendance externe)
- `config/database.php` : Support des variables d'environnement + sécurité

## 🚀 Installation et Configuration

### Étape 1 : Variables d'environnement (Optionnel mais recommandé)
```bash
# Copier le fichier d'exemple
cp .env.example .env

# Éditer le fichier .env avec vos paramètres
nano .env
```

### Étape 2 : Configuration base de données
Dans `.env`, configurez :
```env
DB_HOST=localhost
DB_NAME=mecasos
DB_USER=root
DB_PASS=root
```

### Étape 3 : Tester localement
1. Démarrer votre serveur web local (Apache/Nginx)
2. Pointer vers le dossier du projet
3. Ouvrir http://localhost dans votre navigateur

## 🔧 Détails techniques

### URLs automatiques
- **Localhost** : `/` et `assets/`
- **Production** : `https://mecasos.geniustechnologie.com/`

### Fonctionnalités locales
- ✅ URLs relatives automatiques
- ✅ Avatars générés localement (SVG)
- ✅ Debug activé automatiquement
- ✅ Erreurs détaillées en développement

### Sécurité
- Variables d'environnement supportées
- Configuration de fallback pour la compatibilité
- Gestion d'erreurs améliorée

## 🐛 Dépannage

### Si les CSS/JS ne se chargent pas :
1. Vérifiez que les fichiers existent dans `assets/`
2. Vérifiez les permissions des fichiers
3. Consultez la console du navigateur pour les erreurs 404

### Si la base de données ne connecte pas :
1. Vérifiez vos identifiants dans `.env`
2. Vérifiez que MySQL/MariaDB fonctionne
3. Vérifiez que la base de données existe

### Pour forcer le mode debug :
Modifiez `config/constants.php` et définissez `DEBUG_MODE` à `true`

## 📝 Notes
- Le projet fonctionne maintenant sur localhost sans modification manuelle
- Toutes les URLs sont automatiquement adaptées selon l'environnement
- Les avatars sont générés localement (plus rapides + pas de dépendance externe)