<?php
require_once __DIR__ . '/../config/constants.php';
require_once __DIR__ . '/../config/functions.php';

// Redirection si déjà connecté
if (isLoggedIn()) {
    redirect('index.php');
}

// Traitement du formulaire de connexion
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // En environnement local, accepter toute connexion pour les tests
    if (isLocalEnvironment()) {
        // Simuler une connexion locale
        $_SESSION['admin_id'] = 1;
        $_SESSION['admin_username'] = $username;
        $_SESSION['admin_role'] = 'admin';
        
        // Rediriger vers le dashboard
        redirect('index.php', 'Connexion réussie !', 'success');
    } else {
        // En production, vérifier les identifiants réels
        // TODO: Implémenter la vérification des identifiants réels
        redirect('auth/login.php', 'Identifiants invalides', 'danger');
    }
}

$pageTitle = 'Connexion';
$contentFile = null; // Pas de fichier externe
$pageContent = null;
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?> | MECASOS Admin</title>
    
    <!-- Favicon -->
    <link rel="icon" href="<?= ASSETS_URL ?>img/favicon.png">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <!-- Bootstrap 5.3 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- Custom CSS -->
    <link href="<?= ASSETS_URL ?>css/custom.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-gold: #E1A004;
            --primary-dark: #1D1D1B;
            --bg-dark: #0A0A0A;
            --bg-card: #1A1A1A;
            --bg-hover: #252525;
            --text-primary: #FFFFFF;
            --text-secondary: #A0A0A0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, var(--bg-dark) 0%, #1A1A1A 100%);
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: var(--bg-card);
            border: 1px solid rgba(225, 160, 4, 0.2);
            border-radius: 20px;
            padding: 3rem;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.5);
            position: relative;
            overflow: hidden;
        }
        
        .login-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-gold) 0%, #F5B800 100%);
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .login-title {
            font-family: 'Poppins', sans-serif;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }
        
        .login-subtitle {
            color: var(--text-secondary);
            font-size: 0.9rem;
        }
        
        .form-floating {
            margin-bottom: 1.5rem;
        }
        
        .form-floating > .form-control {
            background: var(--bg-hover);
            border: 1px solid rgba(225, 160, 4, 0.3);
            color: var(--text-primary);
            border-radius: 10px;
        }
        
        .form-floating > .form-control:focus {
            background: var(--bg-hover);
            border-color: var(--primary-gold);
            box-shadow: 0 0 0 0.2rem rgba(225, 160, 4, 0.25);
            color: var(--text-primary);
        }
        
        .form-floating > label {
            color: var(--text-secondary);
        }
        
        .btn-login {
            background: linear-gradient(135deg, var(--primary-gold) 0%, #F5B800 100%);
            border: none;
            border-radius: 10px;
            padding: 0.8rem;
            font-weight: 600;
            font-family: 'Poppins', sans-serif;
            color: var(--primary-dark);
            width: 100%;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(225, 160, 4, 0.3);
            background: linear-gradient(135deg, #F5B800 0%, var(--primary-gold) 100%);
        }
        
        .alert {
            border-radius: 10px;
            border: none;
        }
        
        .alert-success {
            background: rgba(16, 185, 129, 0.1);
            color: #10B981;
            border-left: 4px solid #10B981;
        }
        
        .alert-danger {
            background: rgba(239, 68, 68, 0.1);
            color: #EF4444;
            border-left: 4px solid #EF4444;
        }
        
        .login-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(225, 160, 4, 0.2);
        }
        
        .login-footer small {
            color: var(--text-secondary);
        }
        
        .logo {
            font-size: 2rem;
            color: var(--primary-gold);
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <div class="logo">
                <i class="bi bi-gear-fill"></i>
            </div>
            <h1 class="login-title">MECASOS Admin</h1>
            <p class="login-subtitle">Connexion à l'espace d'administration</p>
        </div>
        
        <?php displayFlash(); ?>
        
        <form method="POST" action="">
            <div class="form-floating">
                <input type="text" class="form-control" id="username" name="username" placeholder="Nom d'utilisateur" required>
                <label for="username">Nom d'utilisateur</label>
            </div>
            
            <div class="form-floating">
                <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe" required>
                <label for="password">Mot de passe</label>
            </div>
            
            <button type="submit" class="btn btn-login">
                <i class="bi bi-box-arrow-in-right me-2"></i>
                Se connecter
            </button>
        </form>
        
        <div class="login-footer">
            <?php if (isLocalEnvironment()): ?>
                <small class="text-success">
                    <i class="bi bi-check-circle me-1"></i>
                    Environnement de test local détecté
                </small>
                <br><br>
                <small class="text-muted">
                    Tout nom d'utilisateur/mot de passe accepté pour les tests
                </small>
            <?php else: ?>
                <small>
                    <i class="bi bi-shield-check me-1"></i>
                    Environnement de production
                </small>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>