<?php
// Détection automatique de l'environnement
function isLocalEnvironment() {
    $localhosts = ['localhost', '127.0.0.1', '::1'];
    $localDomains = ['.local', '.test', '.dev'];
    
    $host = $_SERVER['HTTP_HOST'] ?? '';
    
    // Extraire juste le nom de domaine sans le port
    $hostname = explode(':', $host)[0];
    
    // Vérifier si c'est localhost (avec ou sans port)
    if (in_array($host, $localhosts) || in_array($hostname, $localhosts)) {
        return true;
    }
    
    // Vérifier si c'est un domaine local
    foreach ($localDomains as $domain) {
        if (strpos($host, $domain) !== false) {
            return true;
        }
    }
    
    return false;
}

// Configuration des URLs selon l'environnement
$isLocal = isLocalEnvironment();

if ($isLocal) {
    // Configuration locale
    define('BASE_URL', '/'); // URL relative pour localhost
    define('ASSETS_URL', 'assets/'); // Chemin relatif pour les assets
    define('DEBUG_MODE', true); // Activer le debug en local
} else {
    // Configuration production
    define('BASE_URL', 'https://mecasos.geniustechnologie.com/');
    define('ASSETS_URL', BASE_URL . 'assets/');
    define('DEBUG_MODE', false); // Désactiver le debug en production
}

// Pagination
define('ITEMS_PER_PAGE', 15);

// Upload
define('UPLOAD_PATH', __DIR__ . '/../uploads/');
define('MAX_FILE_SIZE', 5242880); // 5MB

// Status
define('STATUS_PENDING', 'pending');
define('STATUS_ACCEPTED', 'accepted');
define('STATUS_IN_PROGRESS', 'in_progress');
define('STATUS_COMPLETED', 'completed');
define('STATUS_CANCELLED', 'cancelled');

// User roles
define('ROLE_ADMIN', 'admin');
define('ROLE_SUPER_ADMIN', 'super_admin');
define('ROLE_MODERATOR', 'moderator');

// Commission
define('COMMISSION_RATE', 0.15); // 15%

// Session
session_start();
date_default_timezone_set('Africa/Lome');

// Mock data mode (à désactiver en production)
define('USE_MOCK_DATA', true);
?>