<?php
// Informations système
$systemVersion = '1.0.0';
$lastUpdate = '2025-11-21';
$currentYear = date('Y');
$serverTime = date('H:i:s');
?>

<!-- Footer -->
<footer class="dashboard-footer">
    <div class="footer-container">
        <!-- Footer Main Content -->
        <div class="footer-main">
            <div class="row g-4">
                <!-- Colonne 1 : À propos -->
                <div class="col-lg-3 col-md-6">
                    <div class="footer-section">
                        <h6 class="footer-title">
                            <i class="bi bi-info-circle-fill"></i>
                            À propos
                        </h6>
                        <p class="footer-text">
                            MECASOS Admin Dashboard - Plateforme de gestion complète pour services de dépannage automobile premium.
                        </p>
                        <div class="footer-badge">
                            <span class="badge bg-gold">Version <?= $systemVersion ?></span>
                        </div>
                    </div>
                </div>

                <!-- Colonne 2 : Liens rapides -->
                <div class="col-lg-3 col-md-6">
                    <div class="footer-section">
                        <h6 class="footer-title">
                            <i class="bi bi-link-45deg"></i>
                            Liens rapides
                        </h6>
                        <ul class="footer-links">
                            <li>
                                <a href="<?= BASE_URL ?>index.php">
                                    <i class="bi bi-chevron-right"></i>
                                    Dashboard
                                </a>
                            </li>
                            <li>
                                <a href="<?= BASE_URL ?>pages/users/clients.php">
                                    <i class="bi bi-chevron-right"></i>
                                    Gestion utilisateurs
                                </a>
                            </li>
                            <li>
                                <a href="<?= BASE_URL ?>pages/interventions/list.php">
                                    <i class="bi bi-chevron-right"></i>
                                    Interventions
                                </a>
                            </li>
                            <li>
                                <a href="<?= BASE_URL ?>pages/finances/overview.php">
                                    <i class="bi bi-chevron-right"></i>
                                    Finances
                                </a>
                            </li>
                            <li>
                                <a href="<?= BASE_URL ?>pages/settings/general.php">
                                    <i class="bi bi-chevron-right"></i>
                                    Paramètres
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Colonne 3 : Statistiques temps réel -->
                <div class="col-lg-3 col-md-6">
                    <div class="footer-section">
                        <h6 class="footer-title">
                            <i class="bi bi-graph-up-arrow"></i>
                            Stats en direct
                        </h6>
                        <div class="footer-stats">
                            <div class="footer-stat-item">
                                <div class="stat-indicator online"></div>
                                <div class="stat-info">
                                    <span class="stat-value" id="liveUsers">1,247</span>
                                    <span class="stat-label">Utilisateurs</span>
                                </div>
                            </div>
                            <div class="footer-stat-item">
                                <div class="stat-indicator warning"></div>
                                <div class="stat-info">
                                    <span class="stat-value" id="liveInterventions">23</span>
                                    <span class="stat-label">Interventions actives</span>
                                </div>
                            </div>
                            <div class="footer-stat-item">
                                <div class="stat-indicator success"></div>
                                <div class="stat-info">
                                    <span class="stat-value" id="liveMechanics">47</span>
                                    <span class="stat-label">Mécaniciens en ligne</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Colonne 4 : Informations système -->
                <div class="col-lg-3 col-md-6">
                    <div class="footer-section">
                        <h6 class="footer-title">
                            <i class="bi bi-gear-fill"></i>
                            Système
                        </h6>
                        <ul class="footer-info-list">
                            <li>
                                <i class="bi bi-clock"></i>
                                <span>Heure serveur : <strong id="serverClock"><?= $serverTime ?></strong></span>
                            </li>
                            <li>
                                <i class="bi bi-calendar-check"></i>
                                <span>Dernière MAJ : <strong><?= formatDate($lastUpdate, 'd/m/Y') ?></strong></span>
                            </li>
                            <li>
                                <i class="bi bi-database"></i>
                                <span>Base de données : <strong class="text-success">Connectée</strong></span>
                            </li>
                            <li>
                                <i class="bi bi-shield-check"></i>
                                <span>Sécurité : <strong class="text-success">Active</strong></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Bottom Bar -->
        <div class="footer-bottom">
            <div class="footer-bottom-left">
                <p class="copyright">
                    &copy; <?= $currentYear ?> <strong>MECASOS</strong>. Tous droits réservés.
                </p>
                <span class="separator">|</span>
                <p class="made-with">
                    Développé avec <i class="bi bi-heart-fill text-danger"></i> pour l'excellence
                </p>
            </div>

            <div class="footer-bottom-right">
                <a href="#" class="footer-bottom-link">
                    <i class="bi bi-file-text"></i>
                    Documentation
                </a>
                <a href="#" class="footer-bottom-link">
                    <i class="bi bi-life-preserver"></i>
                    Support
                </a>
                <a href="#" class="footer-bottom-link">
                    <i class="bi bi-shield-lock"></i>
                    Confidentialité
                </a>
                <button class="btn-scroll-top" id="scrollTopBtn" title="Retour en haut">
                    <i class="bi bi-arrow-up"></i>
                </button>
            </div>
        </div>
    </div>
</footer>

<!-- Toast Container pour notifications -->
<div class="toast-container position-fixed bottom-0 end-0 p-3" style="z-index: 9999;">
    <!-- Les toasts seront injectés dynamiquement ici -->
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="loading-spinner">
        <div class="spinner-ring"></div>
        <div class="spinner-ring"></div>
        <div class="spinner-ring"></div>
        <p class="loading-text">Chargement en cours...</p>
    </div>
</div>

<script>
// ============================================
// FOOTER INTERACTIONS
// ============================================

document.addEventListener('DOMContentLoaded', function() {
    
    // ========================================
    // SERVER CLOCK UPDATE
    // ========================================
    function updateServerClock() {
        const clockElement = document.getElementById('serverClock');
        if (clockElement) {
            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');
            clockElement.textContent = `${hours}:${minutes}:${seconds}`;
        }
    }
    
    // Mettre à jour chaque seconde
    setInterval(updateServerClock, 1000);
    updateServerClock();
    
    // ========================================
    // LIVE STATS UPDATE (Simulation)
    // ========================================
    function updateLiveStats() {
        // Simulation d'update des stats en temps réel
        const liveUsers = document.getElementById('liveUsers');
        const liveInterventions = document.getElementById('liveInterventions');
        const liveMechanics = document.getElementById('liveMechanics');
        
        if (liveUsers) {
            // Variation aléatoire ±5
            const currentValue = parseInt(liveUsers.textContent.replace(/,/g, ''));
            const newValue = currentValue + Math.floor(Math.random() * 10) - 5;
            liveUsers.textContent = newValue.toLocaleString('fr-FR');
        }
        
        if (liveInterventions) {
            const currentValue = parseInt(liveInterventions.textContent);
            const newValue = Math.max(0, currentValue + Math.floor(Math.random() * 3) - 1);
            liveInterventions.textContent = newValue;
        }
        
        if (liveMechanics) {
            const currentValue = parseInt(liveMechanics.textContent);
            const newValue = Math.max(0, currentValue + Math.floor(Math.random() * 4) - 2);
            liveMechanics.textContent = newValue;
        }
    }
    
    // Mettre à jour toutes les 5 secondes
    setInterval(updateLiveStats, 5000);
    
    // ========================================
    // SCROLL TO TOP BUTTON
    // ========================================
    const scrollTopBtn = document.getElementById('scrollTopBtn');
    
    window.addEventListener('scroll', function() {
        if (window.pageYOffset > 300) {
            scrollTopBtn.classList.add('visible');
        } else {
            scrollTopBtn.classList.remove('visible');
        }
    });
    
    if (scrollTopBtn) {
        scrollTopBtn.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    }
    
    // ========================================
    // STAT INDICATORS PULSE ANIMATION
    // ========================================
    const indicators = document.querySelectorAll('.stat-indicator');
    indicators.forEach((indicator, index) => {
        setTimeout(() => {
            indicator.style.animation = 'pulse 2s infinite';
        }, index * 200);
    });
});

// ============================================
// UTILITY FUNCTIONS
// ============================================

/**
 * Afficher une notification toast
 */
function showToast(message, type = 'info', duration = 3000) {
    const toastContainer = document.querySelector('.toast-container');
    const toastId = 'toast-' + Date.now();
    
    const icons = {
        success: 'bi-check-circle-fill',
        error: 'bi-x-circle-fill',
        warning: 'bi-exclamation-triangle-fill',
        info: 'bi-info-circle-fill'
    };
    
    const colors = {
        success: 'success',
        error: 'danger',
        warning: 'warning',
        info: 'primary'
    };
    
    const toastHTML = `
        <div class="toast align-items-center text-bg-${colors[type]} border-0" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">
                    <i class="bi ${icons[type]} me-2"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    `;
    
    toastContainer.insertAdjacentHTML('beforeend', toastHTML);
    
    const toastElement = document.getElementById(toastId);
    const toast = new bootstrap.Toast(toastElement, {
        autohide: true,
        delay: duration
    });
    
    toast.show();
    
    // Supprimer du DOM après fermeture
    toastElement.addEventListener('hidden.bs.toast', function() {
        toastElement.remove();
    });
}

/**
 * Afficher/Masquer le loading overlay
 */
function toggleLoading(show = true) {
    const overlay = document.getElementById('loadingOverlay');
    if (overlay) {
        if (show) {
            overlay.classList.add('active');
            document.body.style.overflow = 'hidden';
        } else {
            overlay.classList.remove('active');
            document.body.style.overflow = '';
        }
    }
}

/**
 * Formater un nombre avec séparateurs
 */
function formatNumber(num) {
    return num.toLocaleString('fr-FR');
}

/**
 * Formater une devise (FCFA)
 */
function formatCurrency(amount) {
    return formatNumber(amount) + ' FCFA';
}
</script>