<?php
class Database {
    private $host;
    private $db_name;
    private $username;
    private $password;
    public $conn;

    public function __construct() {
        // Utiliser les variables d'environnement si disponibles, sinon fallback vers valeurs par défaut
        $this->host = $_ENV['DB_HOST'] ?? 'localhost';
        $this->db_name = $_ENV['DB_NAME'] ?? 'geniuste_mecasos';
        $this->username = $_ENV['DB_USER'] ?? 'geniuste_mecasos';
        $this->password = $_ENV['DB_PASS'] ?? 'fc3tVp_FkQC2xqys';
    }

    public function getConnection() {
        $this->conn = null;
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            $this->conn->exec("set names utf8mb4");
        } catch(PDOException $exception) {
            // En développement, afficher l'erreur, en production la logger
            if (defined('DEBUG_MODE') && DEBUG_MODE) {
                echo "Connection error: " . $exception->getMessage();
            } else {
                error_log("Database connection error: " . $exception->getMessage());
                echo "Une erreur de connexion est survenue. Veuillez réessayer plus tard.";
            }
        }
        return $this->conn;
    }
}
?>