<?php
/**
 * Fonctions utilitaires globales
 */

// Formater une date
function formatDate($date, $format = 'd/m/Y H:i') {
    return date($format, strtotime($date));
}

// Formater un montant
function formatCurrency($amount) {
    return number_format($amount, 0, ',', ' ') . ' FCFA';
}

// Calculer la commission
function calculateCommission($amount) {
    return $amount * COMMISSION_RATE;
}

// Générer un avatar par défaut (version locale)
function getDefaultAvatar($name) {
    // Version locale : utiliser un avatar SVG généré
    $initials = strtoupper(substr($name, 0, 2)); // Prendre 2 lettres
    $colors = ['E1A004', '10B981', '3B82F6', 'F59E0B', '8B5CF6', 'EF4444'];
    $colorIndex = ord($name[0]) % count($colors);
    $backgroundColor = $colors[$colorIndex];
    
    $svg = '<svg width="128" height="128" xmlns="http://www.w3.org/2000/svg">
        <rect width="128" height="128" fill="#' . $backgroundColor . '"/>
        <text x="64" y="76" font-family="Arial, sans-serif" font-size="48" font-weight="bold" 
              fill="#1D1D1B" text-anchor="middle">' . $initials . '</text>
    </svg>';
    
    return 'data:image/svg+xml;base64,' . base64_encode($svg);
}

// Statut badge HTML
function getStatusBadge($status) {
    $badges = [
        'pending' => '<span class="badge bg-warning">En attente</span>',
        'accepted' => '<span class="badge bg-info">Accepté</span>',
        'in_progress' => '<span class="badge bg-primary">En cours</span>',
        'completed' => '<span class="badge bg-success">Terminé</span>',
        'cancelled' => '<span class="badge bg-danger">Annulé</span>',
    ];
    return $badges[$status] ?? '<span class="badge bg-secondary">Inconnu</span>';
}

// Temps relatif (il y a X minutes/heures)
function timeAgo($datetime) {
    $timestamp = strtotime($datetime);
    $diff = time() - $timestamp;
    
    if ($diff < 60) return "à l'instant";
    if ($diff < 3600) return floor($diff / 60) . " min";
    if ($diff < 86400) return floor($diff / 3600) . " h";
    if ($diff < 604800) return floor($diff / 86400) . " j";
    return formatDate($datetime, 'd/m/Y');
}

// Sécuriser les sorties HTML
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Vérifier si admin connecté
function isLoggedIn() {
    return isset($_SESSION['admin_id']);
}

// Redirection avec message flash
function redirect($page, $message = '', $type = 'success') {
    if ($message) {
        $_SESSION['flash_message'] = $message;
        $_SESSION['flash_type'] = $type;
    }
    header("Location: " . BASE_URL . $page);
    exit();
}

// Afficher message flash
function displayFlash() {
    if (isset($_SESSION['flash_message'])) {
        $type = $_SESSION['flash_type'] ?? 'info';
        $message = $_SESSION['flash_message'];
        echo "<div class='alert alert-{$type} alert-dismissible fade show' role='alert'>
                {$message}
                <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
              </div>";
        unset($_SESSION['flash_message']);
        unset($_SESSION['flash_type']);
    }
}
?>