<?php
// Déterminer la page active
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$currentDir = basename(dirname($_SERVER['PHP_SELF']));

function isActive($page, $dir = '') {
    global $currentPage, $currentDir;
    if ($dir) {
        return ($currentDir === $dir) ? 'active' : '';
    }
    return ($currentPage === $page) ? 'active' : '';
}

// Simuler les notifications (mockdata)
$pendingVerifications = 5;
$activeInterventions = 23;
$newMessages = 12;
?>

<!-- Sidebar -->
<aside class="sidebar" id="sidebar">
    <!-- Logo & Brand -->
    <div class="sidebar-header">
        <div class="brand">
             
            <div class="brand-text">
                <h4 class="brand-title">MECASOS</h4>
                <span class="brand-subtitle">Admin Dashboard</span>
            </div>
        </div>
        <button class="sidebar-toggle" id="sidebarToggle">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>

    <!-- Sidebar Collapse Toggle (Desktop only) -->
    <button class="sidebar-collapse-toggle" id="sidebarCollapseToggle" title="Réduire/Étendre la sidebar">
        <i class="bi bi-chevron-left"></i>
    </button>

    <!-- Search Bar -->
    <div class="sidebar-search">
        <div class="search-wrapper">
            <i class="bi bi-search search-icon"></i>
            <input type="text" class="form-control search-input" placeholder="Rechercher... (Ctrl+K)" id="globalSearch">
            <kbd class="search-kbd">⌘K</kbd>
        </div>
    </div>

    <!-- Navigation Menu -->
    <nav class="sidebar-nav">
        <div class="nav-section">
            <span class="nav-section-title">PRINCIPAL</span>
            
            <!-- Dashboard -->
            <a href="<?= BASE_URL ?>index.php" class="nav-item <?= isActive('index') ?>" data-tooltip="Tableau de bord">
                <div class="nav-item-icon">
                    <i class="bi bi-grid-fill"></i>
                </div>
                <span class="nav-item-text">Tableau de bord</span>
            </a>

            <!-- Carte en temps réel -->
            <a href="<?= BASE_URL ?>pages/map.php" class="nav-item <?= isActive('map') ?>" data-tooltip="Carte en direct">
                <div class="nav-item-icon">
                    <i class="bi bi-map-fill"></i>
                </div>
                <span class="nav-item-text">Carte en direct</span>
                <span class="nav-badge badge-pulse"><?= $activeInterventions ?></span>
            </a>
        </div>

        <div class="nav-section">
            <span class="nav-section-title">GESTION</span>
            
            <!-- Utilisateurs (avec sous-menu) -->
            <div class="nav-item has-submenu <?= isActive('', 'users') ?>">
                <div class="nav-item-wrapper">
                    <div class="nav-item-icon">
                        <i class="bi bi-people-fill"></i>
                    </div>
                    <span class="nav-item-text">Utilisateurs</span>
                    <i class="bi bi-chevron-down nav-arrow"></i>
                </div>
                <div class="nav-submenu">
                    <a href="<?= BASE_URL ?>pages/users/clients.php" class="nav-subitem <?= isActive('clients') ?>">
                        <i class="bi bi-person"></i>
                        <span>Clients</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/users/mechanics.php" class="nav-subitem <?= isActive('mechanics') ?>">
                        <i class="bi bi-wrench"></i>
                        <span>Mécaniciens</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/users/verifications.php" class="nav-subitem <?= isActive('verifications') ?>">
                        <i class="bi bi-shield-check"></i>
                        <span>Vérifications</span>
                        <?php if($pendingVerifications > 0): ?>
                        <span class="nav-badge badge-warning"><?= $pendingVerifications ?></span>
                        <?php endif; ?>
                    </a>
                    <a href="<?= BASE_URL ?>pages/users/banned.php" class="nav-subitem <?= isActive('banned') ?>">
                        <i class="bi bi-ban"></i>
                        <span>Bannis</span>
                    </a>
                </div>
            </div>

            <!-- Interventions (avec sous-menu) -->
            <div class="nav-item has-submenu <?= isActive('', 'interventions') ?>">
                <div class="nav-item-wrapper">
                    <div class="nav-item-icon">
                        <i class="bi bi-tools"></i>
                    </div>
                    <span class="nav-item-text">Interventions</span>
                    <i class="bi bi-chevron-down nav-arrow"></i>
                </div>
                <div class="nav-submenu">
                    <a href="<?= BASE_URL ?>pages/interventions/active.php" class="nav-subitem">
                        <i class="bi bi-hourglass-split"></i>
                        <span>En cours</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/interventions/pending.php" class="nav-subitem">
                        <i class="bi bi-clock"></i>
                        <span>En attente</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/interventions/completed.php" class="nav-subitem">
                        <i class="bi bi-check-circle"></i>
                        <span>Terminées</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/interventions/cancelled.php" class="nav-subitem">
                        <i class="bi bi-x-circle"></i>
                        <span>Annulées</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/interventions/disputes.php" class="nav-subitem">
                        <i class="bi bi-exclamation-triangle"></i>
                        <span>Litiges</span>
                    </a>
                </div>
            </div>
        </div>

        <div class="nav-section">
            <span class="nav-section-title">FINANCIER</span>
            
            <!-- Finances (avec sous-menu) -->
            <div class="nav-item has-submenu <?= isActive('', 'finances') ?>">
                <div class="nav-item-wrapper">
                    <div class="nav-item-icon">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <span class="nav-item-text">Finances</span>
                    <i class="bi bi-chevron-down nav-arrow"></i>
                </div>
                <div class="nav-submenu">
                    <a href="<?= BASE_URL ?>pages/finances/overview.php" class="nav-subitem">
                        <i class="bi bi-graph-up"></i>
                        <span>Vue d'ensemble</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/finances/transactions.php" class="nav-subitem">
                        <i class="bi bi-receipt"></i>
                        <span>Transactions</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/finances/commissions.php" class="nav-subitem">
                        <i class="bi bi-percent"></i>
                        <span>Commissions</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/finances/withdrawals.php" class="nav-subitem">
                        <i class="bi bi-cash-stack"></i>
                        <span>Retraits</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/finances/refunds.php" class="nav-subitem">
                        <i class="bi bi-arrow-return-left"></i>
                        <span>Remboursements</span>
                    </a>
                </div>
            </div>
        </div>

        <div class="nav-section">
            <span class="nav-section-title">COMMUNICATION</span>
            
            <!-- Notifications -->
            <a href="<?= BASE_URL ?>pages/notifications.php" class="nav-item <?= isActive('notifications') ?>" data-tooltip="Notifications">
                <div class="nav-item-icon">
                    <i class="bi bi-bell-fill"></i>
                </div>
                <span class="nav-item-text">Notifications</span>
                <?php if($newMessages > 0): ?>
                <span class="nav-badge badge-danger"><?= $newMessages ?></span>
                <?php endif; ?>
            </a>

            <!-- Avis & Notes -->
            <a href="<?= BASE_URL ?>pages/reviews.php" class="nav-item <?= isActive('reviews') ?>" data-tooltip="Avis & Notes">
                <div class="nav-item-icon">
                    <i class="bi bi-star-fill"></i>
                </div>
                <span class="nav-item-text">Avis & Notes</span>
            </a>
        </div>

        <div class="nav-section">
            <span class="nav-section-title">ANALYSE</span>
            
            <!-- Analytics -->
            <a href="<?= BASE_URL ?>pages/analytics.php" class="nav-item <?= isActive('analytics') ?>" data-tooltip="Analytics">
                <div class="nav-item-icon">
                    <i class="bi bi-bar-chart-fill"></i>
                </div>
                <span class="nav-item-text">Analytics</span>
            </a>

            <!-- Rapports -->
            <a href="<?= BASE_URL ?>pages/reports.php" class="nav-item <?= isActive('reports') ?>" data-tooltip="Rapports">
                <div class="nav-item-icon">
                    <i class="bi bi-file-earmark-text-fill"></i>
                </div>
                <span class="nav-item-text">Rapports</span>
            </a>
        </div>

        <div class="nav-section">
            <span class="nav-section-title">SYSTÈME</span>
            
            <!-- Paramètres (avec sous-menu) -->
            <div class="nav-item has-submenu <?= isActive('', 'settings') ?>">
                <div class="nav-item-wrapper">
                    <div class="nav-item-icon">
                        <i class="bi bi-gear-fill"></i>
                    </div>
                    <span class="nav-item-text">Paramètres</span>
                    <i class="bi bi-chevron-down nav-arrow"></i>
                </div>
                <div class="nav-submenu">
                    <a href="<?= BASE_URL ?>pages/settings/general.php" class="nav-subitem">
                        <i class="bi bi-sliders"></i>
                        <span>Général</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/settings/pricing.php" class="nav-subitem">
                        <i class="bi bi-tag"></i>
                        <span>Tarification</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/settings/services.php" class="nav-subitem">
                        <i class="bi bi-list-check"></i>
                        <span>Types de services</span>
                    </a>
                    <a href="<?= BASE_URL ?>pages/settings/zones.php" class="nav-subitem">
                        <i class="bi bi-geo-alt"></i>
                        <span>Zones de service</span>
                    </a>
                </div>
            </div>

            <!-- Administrateurs -->
            <a href="<?= BASE_URL ?>pages/admins.php" class="nav-item <?= isActive('admins') ?>" data-tooltip="Administrateurs">
                <div class="nav-item-icon">
                    <i class="bi bi-shield-lock-fill"></i>
                </div>
                <span class="nav-item-text">Administrateurs</span>
            </a>

            <!-- Logs -->
            <a href="<?= BASE_URL ?>pages/logs.php" class="nav-item <?= isActive('logs') ?>" data-tooltip="Logs système">
                <div class="nav-item-icon">
                    <i class="bi bi-journal-text"></i>
                </div>
                <span class="nav-item-text">Logs système</span>
            </a>
        </div>
    </nav>

    <!-- Sidebar Footer (User Profile) -->
    <div class="sidebar-footer">
        <div class="user-profile">
            <img src="<?= getDefaultAvatar('Admin MECASOS') ?>" alt="Admin" class="user-avatar">
            <div class="user-info">
                <h6 class="user-name">Admin MECASOS</h6>
                <span class="user-role">Super Administrateur</span>
            </div>
            <div class="dropdown">
                <button class="btn btn-link user-menu-btn" data-bs-toggle="dropdown">
                    <i class="bi bi-three-dots-vertical"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end">
                    <li><a class="dropdown-item" href="<?= BASE_URL ?>pages/profile.php">
                        <i class="bi bi-person"></i> Mon profil
                    </a></li>
                    <li><a class="dropdown-item" href="<?= BASE_URL ?>pages/settings/general.php">
                        <i class="bi bi-gear"></i> Paramètres
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="<?= BASE_URL ?>auth/logout.php">
                        <i class="bi bi-box-arrow-right"></i> Déconnexion
                    </a></li>
                </ul>
            </div>
        </div>
        
        <!-- Theme Toggle -->
        <button class="theme-toggle" id="themeToggle" title="Changer le thème">
            <i class="bi bi-moon-stars-fill"></i>
        </button>
    </div>
</aside>

<!-- Sidebar Overlay (mobile) -->
<div class="sidebar-overlay" id="sidebarOverlay"></div>