<?php
$pageTitle = 'Liste des Interventions';
$breadcrumbs = [
    ['label' => 'Dashboard', 'url' => '../index.php'],
    ['label' => 'Interventions', 'url' => '#'],
    ['label' => 'Liste', 'url' => '#']
];

require_once __DIR__ . '/../../config/constants.php';
require_once __DIR__ . '/../../config/functions.php';

// Charger les données mock
$interventionsData = json_decode(file_get_contents(__DIR__ . '/../../mockdata/interventions.json'), true);
$usersData = json_decode(file_get_contents(__DIR__ . '/../../mockdata/users.json'), true);
$mechanicsData = json_decode(file_get_contents(__DIR__ . '/../../mockdata/mechanics.json'), true);

$interventions = $interventionsData['interventions'];
$stats = $interventionsData['stats'];

// Filtres (simulation)
$statusFilter = $_GET['status'] ?? 'all';
$typeFilter = $_GET['type'] ?? 'all';
$dateFilter = $_GET['date'] ?? 'all';

// Appliquer les filtres
$filteredInterventions = array_filter($interventions, function($intervention) use ($statusFilter, $typeFilter) {
    if ($statusFilter !== 'all' && $intervention['status'] !== $statusFilter) return false;
    if ($typeFilter !== 'all' && $intervention['type'] !== $typeFilter) return false;
    return true;
});

// Pagination
$page = $_GET['page'] ?? 1;
$perPage = 15;
$totalPages = ceil(count($filteredInterventions) / $perPage);
$offset = ($page - 1) * $perPage;
$pagedInterventions = array_slice($filteredInterventions, $offset, $perPage);
?>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <h1 class="page-title">
            <i class="bi bi-tools"></i>
            Interventions
        </h1>
        <p class="page-subtitle">Gestion et suivi des interventions MECASOS</p>
    </div>
    <div class="page-header-actions">
        <div class="view-toggle">
            <button class="btn btn-outline-secondary btn-icon-text active" data-view="list">
                <i class="bi bi-list"></i>
                <span>Liste</span>
            </button>
            <button class="btn btn-outline-secondary btn-icon-text" data-view="map" onclick="window.location.href='../map.php'">
                <i class="bi bi-map"></i>
                <span>Carte</span>
            </button>
        </div>
        <button class="btn btn-primary btn-icon-text" data-bs-toggle="modal" data-bs-target="#newInterventionModal">
            <i class="bi bi-plus-lg"></i>
            <span>Nouvelle Intervention</span>
        </button>
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-xl-2 col-lg-4 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="0">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-warning">
                    <i class="bi bi-clock"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">En attente</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $stats['pending'] ?>">0</span>
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-lg-4 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="100">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-info">
                    <i class="bi bi-play-circle"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">En cours</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $stats['in_progress'] ?>">0</span>
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-lg-4 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="200">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-success">
                    <i class="bi bi-check-circle"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Terminées</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $stats['completed'] ?>">0</span>
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-lg-4 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="300">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-danger">
                    <i class="bi bi-x-circle"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Annulées</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $stats['cancelled'] ?>">0</span>
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-lg-4 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="400">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-gold">
                    <i class="bi bi-currency-dollar"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Revenus totaux</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $stats['total_revenue'] ?>">0</span>
                        <small> FCFA</small>
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-lg-4 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="500">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-primary">
                    <i class="bi bi-star"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Note moyenne</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= number_format($stats['avg_rating'], 1) ?>">0</span>
                        <small>/5</small>
                    </h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters Bar -->
<div class="dashboard-card mb-4">
    <div class="card-body">
        <form method="GET" class="filters-form">
            <div class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">Statut</label>
                    <select name="status" class="form-select">
                        <option value="all" <?= $statusFilter === 'all' ? 'selected' : '' ?>>Tous les statuts</option>
                        <option value="pending" <?= $statusFilter === 'pending' ? 'selected' : '' ?>>En attente</option>
                        <option value="accepted" <?= $statusFilter === 'accepted' ? 'selected' : '' ?>>Accepté</option>
                        <option value="in_progress" <?= $statusFilter === 'in_progress' ? 'selected' : '' ?>>En cours</option>
                        <option value="completed" <?= $statusFilter === 'completed' ? 'selected' : '' ?>>Terminé</option>
                        <option value="cancelled" <?= $statusFilter === 'cancelled' ? 'selected' : '' ?>>Annulé</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label">Type</label>
                    <select name="type" class="form-select">
                        <option value="all" <?= $typeFilter === 'all' ? 'selected' : '' ?>>Tous les types</option>
                        <option value="Batterie" <?= $typeFilter === 'Batterie' ? 'selected' : '' ?>>Batterie</option>
                        <option value="Crevaison" <?= $typeFilter === 'Crevaison' ? 'selected' : '' ?>>Crevaison</option>
                        <option value="Panne sèche" <?= $typeFilter === 'Panne sèche' ? 'selected' : '' ?>>Panne sèche</option>
                        <option value="Mécanique générale" <?= $typeFilter === 'Mécanique générale' ? 'selected' : '' ?>>Mécanique générale</option>
                        <option value="Transmission" <?= $typeFilter === 'Transmission' ? 'selected' : '' ?>>Transmission</option>
                        <option value="Climatisation" <?= $typeFilter === 'Climatisation' ? 'selected' : '' ?>>Climatisation</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label">Date</label>
                    <select name="date" class="form-select">
                        <option value="all" <?= $dateFilter === 'all' ? 'selected' : '' ?>>Toutes les dates</option>
                        <option value="today">Aujourd'hui</option>
                        <option value="yesterday">Hier</option>
                        <option value="week">Cette semaine</option>
                        <option value="month">Ce mois</option>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label">Recherche</label>
                    <input type="text" name="search" class="form-control" placeholder="ID, client, mécanicien...">
                </div>

                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-search"></i>
                            Filtrer
                        </button>
                        <a href="list.php" class="btn btn-outline-secondary">
                            <i class="bi bi-x"></i>
                            Réinitialiser
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="dashboard-card">
    <div class="card-header">
        <div class="card-header-content">
            <h5 class="card-title">
                <i class="bi bi-table"></i>
                Liste des Interventions
            </h5>
            <p class="card-subtitle">
                <?= count($filteredInterventions) ?> interventions trouvées
            </p>
        </div>
        <div class="card-header-actions">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-sm btn-outline-secondary">
                    <i class="bi bi-download"></i>
                    Exporter
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" id="bulkActionsBtn" disabled>
                    <i class="bi bi-three-dots"></i>
                    Actions groupées
                </button>
            </div>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th width="40">
                            <input type="checkbox" class="form-check-input" id="selectAll">
                        </th>
                        <th>ID</th>
                        <th>Client</th>
                        <th>Mécanicien</th>
                        <th>Type</th>
                        <th>Statut</th>
                        <th>Montant</th>
                        <th>Créé</th>
                        <th width="120">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($pagedInterventions as $intervention): ?>
                    <tr>
                        <td>
                            <input type="checkbox" class="form-check-input row-checkbox" value="<?= $intervention['id'] ?>">
                        </td>
                        <td>
                            <div class="intervention-id">
                                <span class="badge bg-dark"><?= $intervention['id'] ?></span>
                            </div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <img src="<?= getDefaultAvatar($intervention['client']) ?>" alt="" class="user-avatar-sm">
                                <div class="user-info">
                                    <span class="user-name"><?= e($intervention['client']) ?></span>
                                    <small class="text-muted"><?= e($intervention['location']) ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <img src="<?= getDefaultAvatar($intervention['mechanic']) ?>" alt="" class="user-avatar-sm">
                                <div class="user-info">
                                    <span class="user-name"><?= e($intervention['mechanic']) ?></span>
                                    <small class="text-muted">⭐ <?= $intervention['rating'] ?? 'N/A' ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="service-badge">
                                <i class="bi bi-tools"></i>
                                <?= e($intervention['type']) ?>
                            </span>
                        </td>
                        <td>
                            <?= getStatusBadge($intervention['status']) ?>
                        </td>
                        <td>
                            <strong class="text-gold">
                                <?= formatCurrency($intervention['amount']) ?>
                            </strong>
                            <?php if($intervention['commission'] > 0): ?>
                            <br><small class="text-muted">Commission: <?= formatCurrency($intervention['commission']) ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small class="text-muted">
                                <i class="bi bi-clock"></i>
                                <?= timeAgo($intervention['created_at']) ?>
                            </small>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <button class="btn btn-sm btn-icon btn-outline-primary" title="Voir détails"
                                        onclick="window.location.href='details.php?id=<?= $intervention['id'] ?>'">
                                    <i class="bi bi-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-icon btn-outline-secondary" title="Modifier"
                                        onclick="editIntervention('<?= $intervention['id'] ?>')">
                                    <i class="bi bi-pencil"></i>
                                </button>
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-icon btn-outline-secondary dropdown-toggle"
                                            type="button" data-bs-toggle="dropdown">
                                        <i class="bi bi-three-dots"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#" onclick="assignMechanic('<?= $intervention['id'] ?>')">
                                            <i class="bi bi-person-plus"></i> Assigner mécanicien
                                        </a></li>
                                        <li><a class="dropdown-item" href="#" onclick="updateStatus('<?= $intervention['id'] ?>')">
                                            <i class="bi bi-arrow-repeat"></i> Changer statut
                                        </a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item text-danger" href="#" onclick="cancelIntervention('<?= $intervention['id'] ?>')">
                                            <i class="bi bi-x-circle"></i> Annuler
                                        </a></li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <?php if($totalPages > 1): ?>
    <div class="card-footer">
        <nav aria-label="Pagination">
            <ul class="pagination justify-content-center">
                <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                    <a class="page-link" href="?page=<?= $page - 1 ?>&status=<?= $statusFilter ?>&type=<?= $typeFilter ?>">
                        <i class="bi bi-chevron-left"></i>
                    </a>
                </li>

                <?php for($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                <li class="page-item <?= $i === $page ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>&status=<?= $statusFilter ?>&type=<?= $typeFilter ?>"><?= $i ?></a>
                </li>
                <?php endfor; ?>

                <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                    <a class="page-link" href="?page=<?= $page + 1 ?>&status=<?= $statusFilter ?>&type=<?= $typeFilter ?>">
                        <i class="bi bi-chevron-right"></i>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
    <?php endif; ?>
</div>

<!-- Modal: New Intervention -->
<div class="modal fade" id="newInterventionModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-plus-circle"></i>
                    Nouvelle Intervention
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="newInterventionForm">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Client</label>
                            <select name="client_id" class="form-select" required>
                                <option value="">Sélectionner un client</option>
                                <?php foreach($usersData['clients'] as $client): ?>
                                <option value="<?= $client['id'] ?>"><?= e($client['name']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Type d'intervention</label>
                            <select name="type" class="form-select" required>
                                <option value="">Sélectionner un type</option>
                                <option value="Batterie">Batterie</option>
                                <option value="Crevaison">Crevaison</option>
                                <option value="Panne sèche">Panne sèche</option>
                                <option value="Mécanique générale">Mécanique générale</option>
                                <option value="Transmission">Transmission</option>
                                <option value="Climatisation">Climatisation</option>
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="3" placeholder="Décrivez le problème..."></textarea>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Localisation</label>
                            <input type="text" name="location" class="form-control" placeholder="Douala, Akwa" required>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Véhicule</label>
                            <input type="text" name="vehicle" class="form-control" placeholder="Marque Modèle" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Créer l'intervention</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// ========================================
// INTERVENTIONS LIST FUNCTIONALITY
// ========================================
document.addEventListener('DOMContentLoaded', function() {
    // Counter animations
    const counters = document.querySelectorAll('.counter');
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-target'));
        const duration = 2000;
        const increment = target / (duration / 16);
        let current = 0;

        const updateCounter = () => {
            current += increment;
            if (current < target) {
                counter.textContent = Math.floor(current).toLocaleString('fr-FR');
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target.toLocaleString('fr-FR');
            }
        };

        setTimeout(updateCounter, 300);
    });

    // Select all checkbox
    const selectAllCheckbox = document.getElementById('selectAll');
    const rowCheckboxes = document.querySelectorAll('.row-checkbox');
    const bulkActionsBtn = document.getElementById('bulkActionsBtn');

    selectAllCheckbox.addEventListener('change', function() {
        rowCheckboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
        updateBulkActions();
    });

    rowCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const checkedBoxes = document.querySelectorAll('.row-checkbox:checked');
            selectAllCheckbox.checked = checkedBoxes.length === rowCheckboxes.length;
            selectAllCheckbox.indeterminate = checkedBoxes.length > 0 && checkedBoxes.length < rowCheckboxes.length;
            updateBulkActions();
        });
    });

    function updateBulkActions() {
        const checkedBoxes = document.querySelectorAll('.row-checkbox:checked');
        bulkActionsBtn.disabled = checkedBoxes.length === 0;
    }

    // Form submission
    document.getElementById('newInterventionForm').addEventListener('submit', function(e) {
        e.preventDefault();

        // Simulation de création
        const formData = new FormData(this);
        console.log('Nouvelle intervention:', Object.fromEntries(formData));

        // Fermer le modal et afficher un message de succès
        const modal = bootstrap.Modal.getInstance(document.getElementById('newInterventionModal'));
        modal.hide();

        // Afficher notification de succès (simulation)
        showNotification('Intervention créée avec succès!', 'success');
    });
});

// Utility functions
function editIntervention(id) {
    console.log('Modifier intervention:', id);
    showNotification('Fonctionnalité en développement', 'info');
}

function assignMechanic(id) {
    console.log('Assigner mécanicien à:', id);
    showNotification('Mécanicien assigné avec succès!', 'success');
}

function updateStatus(id) {
    console.log('Changer statut de:', id);
    showNotification('Statut mis à jour!', 'success');
}

function cancelIntervention(id) {
    if (confirm('Êtes-vous sûr de vouloir annuler cette intervention?')) {
        console.log('Annuler intervention:', id);
        showNotification('Intervention annulée', 'warning');
    }
}

function showNotification(message, type = 'info') {
    // Créer une notification temporaire
    const notification = document.createElement('div');
    notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

    document.body.appendChild(notification);

    // Auto-remove after 5 seconds
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}
</script>

<style>
/* Interventions List Styles */
.view-toggle .btn {
    border-radius: 6px 0 0 6px;
}

.view-toggle .btn:last-child {
    border-radius: 0 6px 6px 0;
}

.view-toggle .btn.active {
    background: var(--primary-color);
    border-color: var(--primary-color);
    color: white;
}

.filters-form .form-label {
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.data-table {
    width: 100%;
    margin-bottom: 0;
}

.data-table thead th {
    background: var(--card-background);
    border-bottom: 2px solid var(--border-color);
    font-weight: 600;
    color: var(--text-primary);
    padding: 16px 12px;
    text-align: left;
}

.data-table tbody td {
    padding: 16px 12px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    vertical-align: middle;
}

.data-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.02);
}

.intervention-id .badge {
    font-size: 11px;
    padding: 4px 8px;
}

.user-cell {
    display: flex;
    align-items: center;
    gap: 10px;
}

.user-avatar-sm {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    object-fit: cover;
}

.user-info {
    display: flex;
    flex-direction: column;
}

.user-name {
    font-weight: 500;
    color: var(--text-primary);
}

.service-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: rgba(225, 160, 4, 0.1);
    color: var(--primary-color);
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 500;
}

.service-badge i {
    font-size: 10px;
}

.btn-group .btn {
    padding: 6px 8px;
}

.btn-icon {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
}

.dropdown-menu {
    background: var(--card-background);
    border: 1px solid var(--border-color);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
}

.dropdown-item {
    color: var(--text-primary);
    padding: 8px 16px;
}

.dropdown-item:hover {
    background: rgba(255, 255, 255, 0.05);
}

.dropdown-item.text-danger:hover {
    background: rgba(220, 53, 69, 0.1);
    color: #dc3545;
}

.pagination {
    margin-bottom: 0;
}

.pagination .page-link {
    background: var(--card-background);
    border-color: var(--border-color);
    color: var(--text-primary);
    padding: 8px 12px;
}

.pagination .page-link:hover {
    background: rgba(255, 255, 255, 0.05);
    border-color: var(--primary-color);
    color: var(--primary-color);
}

.pagination .page-item.active .page-link {
    background: var(--primary-color);
    border-color: var(--primary-color);
}

/* Modal Styles */
.modal-content {
    background: var(--card-background);
    border: 1px solid var(--border-color);
}

.modal-header {
    border-bottom: 1px solid var(--border-color);
}

.modal-footer {
    border-top: 1px solid var(--border-color);
}

/* Responsive */
@media (max-width: 768px) {
    .page-header-actions {
        flex-direction: column;
        gap: 12px;
    }

    .view-toggle {
        width: 100%;
    }

    .view-toggle .btn {
        flex: 1;
    }

    .filters-form .row > div {
        margin-bottom: 16px;
    }

    .data-table {
        font-size: 14px;
    }

    .data-table thead th,
    .data-table tbody td {
        padding: 8px 6px;
    }

    .user-cell {
        flex-direction: column;
        text-align: center;
        gap: 4px;
    }

    .btn-group {
        flex-direction: column;
        gap: 4px;
    }

    .btn-group .btn {
        width: 100%;
    }
}
</style>
