<?php
$pageTitle = 'Gestion des Mécaniciens';
$breadcrumbs = [
    ['label' => 'Dashboard', 'url' => BASE_URL . 'index.php'],
    ['label' => 'Utilisateurs', 'url' => '#'],
    ['label' => 'Mécaniciens', 'url' => '#']
];

// Charger les données mockées
$mechanicsData = json_decode(file_get_contents(__DIR__ . '/../../mockdata/mechanics.json'), true);
$mechanics = $mechanicsData['mechanics'];
$stats = $mechanicsData['stats'];
?>

<!DOCTYPE html>
<html lang="fr" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?> | MECASOS Admin</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">
    
    <link href="<?= ASSETS_URL ?>css/custom.css" rel="stylesheet">
    <link href="<?= ASSETS_URL ?>css/dashboard.css" rel="stylesheet">
    <link href="<?= ASSETS_URL ?>css/users.css" rel="stylesheet">
    <link href="<?= ASSETS_URL ?>css/mechanics.css" rel="stylesheet">
</head>
<body>

<?php include __DIR__ . '/../../includes/sidebar.php'; ?>

<div class="main-wrapper">
    <?php include __DIR__ . '/../../includes/topbar.php'; ?>
    
    <main class="main-content">
        <div class="container-fluid">
            
            <!-- Page Header -->
            <div class="page-header">
                <div class="page-header-content">
                    <h1 class="page-title">
                        <i class="bi bi-wrench"></i>
                        Gestion des Mécaniciens
                    </h1>
                    <p class="page-subtitle">Gérez tous les professionnels de dépannage</p>
                </div>
                <div class="page-header-actions">
                    <button class="btn btn-outline-light btn-icon-text" onclick="viewMap()">
                        <i class="bi bi-map"></i>
                        <span>Carte</span>
                    </button>
                    <button class="btn btn-outline-light btn-icon-text" onclick="exportData()">
                        <i class="bi bi-download"></i>
                        <span>Exporter</span>
                    </button>
                    <button class="btn btn-primary btn-icon-text" data-bs-toggle="modal" data-bs-target="#addMechanicModal">
                        <i class="bi bi-plus-lg"></i>
                        <span>Ajouter un mécanicien</span>
                    </button>
                </div>
            </div>

            <!-- Enhanced Stats Cards Row -->
            <div class="row g-3 mb-4">
                <div class="col-xl-2 col-lg-4 col-md-6">
                    <div class="stat-card stat-card-mini">
                        <div class="stat-icon bg-primary">
                            <i class="bi bi-people"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Total</span>
                            <h3 class="stat-value"><?= number_format($stats['total']) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-6">
                    <div class="stat-card stat-card-mini">
                        <div class="stat-icon bg-success">
                            <i class="bi bi-circle-fill pulse-animation"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">En ligne</span>
                            <h3 class="stat-value text-success"><?= number_format($stats['online']) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-6">
                    <div class="stat-card stat-card-mini">
                        <div class="stat-icon bg-warning">
                            <i class="bi bi-hourglass-split"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Occupés</span>
                            <h3 class="stat-value text-warning"><?= number_format($stats['busy']) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-6">
                    <div class="stat-card stat-card-mini">
                        <div class="stat-icon bg-info">
                            <i class="bi bi-shield-check"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Vérifiés</span>
                            <h3 class="stat-value"><?= number_format($stats['verified']) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-6">
                    <div class="stat-card stat-card-mini">
                        <div class="stat-icon bg-gold">
                            <i class="bi bi-star-fill"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Note Moy.</span>
                            <h3 class="stat-value"><?= $stats['avg_rating'] ?>/5</h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-6">
                    <div class="stat-card stat-card-mini">
                        <div class="stat-icon bg-danger">
                            <i class="bi bi-ban"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Suspendus</span>
                            <h3 class="stat-value text-danger"><?= number_format($stats['suspended']) ?></h3>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters & Table Card -->
            <div class="dashboard-card">
                <div class="card-header">
                    <div class="card-header-content">
                        <h5 class="card-title">
                            <i class="bi bi-table"></i>
                            Liste des Mécaniciens
                        </h5>
                    </div>
                    <div class="card-header-actions">
                        <div class="view-toggle">
                            <button class="btn btn-sm btn-outline-secondary active" data-view="table">
                                <i class="bi bi-table"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" data-view="grid">
                                <i class="bi bi-grid-3x3"></i>
                            </button>
                        </div>
                        <button class="btn btn-sm btn-outline-secondary" id="refreshTable">
                            <i class="bi bi-arrow-clockwise"></i>
                            Actualiser
                        </button>
                    </div>
                </div>

                <!-- Advanced Filters -->
                <div class="card-body border-bottom">
                    <div class="advanced-filters">
                        <div class="row g-3">
                            <div class="col-lg-3 col-md-6">
                                <label class="form-label">Recherche globale</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-search"></i>
                                    </span>
                                    <input type="text" class="form-control" id="globalSearch" placeholder="Nom, email, téléphone...">
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label">Statut en ligne</label>
                                <select class="form-select" id="onlineStatusFilter">
                                    <option value="">Tous</option>
                                    <option value="online">En ligne</option>
                                    <option value="offline">Hors ligne</option>
                                    <option value="busy">Occupé</option>
                                    <option value="suspended">Suspendu</option>
                                </select>
                            </div>
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label">Vérification</label>
                                <select class="form-select" id="verificationFilter">
                                    <option value="">Tous</option>
                                    <option value="verified">Vérifié</option>
                                    <option value="pending">En attente</option>
                                </select>
                            </div>
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label">Spécialité</label>
                                <select class="form-select" id="specialtyFilter">
                                    <option value="">Toutes</option>
                                    <option value="Batterie">Batterie</option>
                                    <option value="Pneus">Pneus</option>
                                    <option value="Crevaison">Crevaison</option>
                                    <option value="Mécanique générale">Mécanique générale</option>
                                    <option value="Diagnostic électronique">Diagnostic</option>
                                </select>
                            </div>
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label">Zone</label>
                                <select class="form-select" id="zoneFilter">
                                    <option value="">Toutes</option>
                                    <option value="Douala">Douala</option>
                                    <option value="Yaoundé">Yaoundé</option>
                                </select>
                            </div>
                            <div class="col-lg-1 col-md-6">
                                <label class="form-label">&nbsp;</label>
                                <button class="btn btn-outline-secondary w-100" id="resetFilters" title="Réinitialiser">
                                    <i class="bi bi-x-circle"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions en masse -->
                <div class="card-body border-bottom" id="bulkActionsBar" style="display: none;">
                    <div class="bulk-actions-bar">
                        <div class="selected-count">
                            <i class="bi bi-check-square"></i>
                            <span id="selectedCount">0</span> mécanicien(s) sélectionné(s)
                        </div>
                        <div class="bulk-actions">
                            <button class="btn btn-sm btn-success" onclick="bulkAction('verify')">
                                <i class="bi bi-shield-check"></i>
                                Vérifier
                            </button>
                            <button class="btn btn-sm btn-info" onclick="bulkAction('notify')">
                                <i class="bi bi-send"></i>
                                Notifier
                            </button>
                            <button class="btn btn-sm btn-warning" onclick="bulkAction('suspend')">
                                <i class="bi bi-ban"></i>
                                Suspendre
                            </button>
                            <button class="btn btn-sm btn-primary" onclick="bulkAction('export')">
                                <i class="bi bi-download"></i>
                                Exporter
                            </button>
                        </div>
                    </div>
                </div>

                <!-- DataTable -->
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table id="mechanicsTable" class="table table-hover mechanics-table" style="width:100%">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" class="form-check-input" id="selectAll">
                                    </th>
                                    <th>ID</th>
                                    <th>Mécanicien</th>
                                    <th>Contact</th>
                                    <th>Statut</th>
                                    <th>Vérification</th>
                                    <th>Spécialités</th>
                                    <th>Interventions</th>
                                    <th>Note</th>
                                    <th>Taux Réussite</th>
                                    <th>Revenus</th>
                                    <th>Performance</th>
                                    <th>Inscription</th>
                                    <th>Dernière activité</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($mechanics as $mechanic): ?>
                                <tr data-mechanic-id="<?= $mechanic['id'] ?>">
                                    <td>
                                        <input type="checkbox" class="form-check-input row-checkbox" value="<?= $mechanic['id'] ?>">
                                    </td>
                                    <td>
                                        <span class="badge bg-dark">#<?= str_pad($mechanic['id'], 4, '0', STR_PAD_LEFT) ?></span>
                                    </td>
                                    <td>
                                        <div class="user-cell">
                                            <div class="user-avatar-wrapper">
                                                <img src="<?= getDefaultAvatar($mechanic['name']) ?>" alt="" class="user-avatar">
                                                <span class="status-indicator status-<?= $mechanic['status'] ?>"></span>
                                            </div>
                                            <div class="user-info">
                                                <span class="user-name"><?= e($mechanic['name']) ?></span>
                                                <span class="user-location">
                                                    <i class="bi bi-geo-alt"></i>
                                                    <?= e($mechanic['location']) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="contact-info">
                                            <div class="contact-item">
                                                <i class="bi bi-envelope"></i>
                                                <span><?= e($mechanic['email']) ?></span>
                                            </div>
                                            <div class="contact-item">
                                                <i class="bi bi-phone"></i>
                                                <span><?= e($mechanic['phone']) ?></span>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?= getOnlineStatusBadge($mechanic['status']) ?></td>
                                    <td><?= getVerificationBadge($mechanic['verification_status']) ?></td>
                                    <td>
                                        <div class="specialties-list">
                                            <?php foreach(array_slice($mechanic['specialties'], 0, 2) as $specialty): ?>
                                                <span class="specialty-badge"><?= e($specialty) ?></span>
                                            <?php endforeach; ?>
                                            <?php if(count($mechanic['specialties']) > 2): ?>
                                                <span class="specialty-badge">+<?= count($mechanic['specialties']) - 2 ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="interventions-stats">
                                            <span class="badge bg-success"><?= $mechanic['completed_interventions'] ?></span>
                                            <small class="text-muted">/ <?= $mechanic['total_interventions'] ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="rating-display">
                                            <i class="bi bi-star-fill text-warning"></i>
                                            <span><?= $mechanic['rating'] ?></span>
                                            <small class="text-muted">(<?= $mechanic['total_reviews'] ?>)</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="completion-rate">
                                            <div class="progress">
                                                <div class="progress-bar bg-success" style="width: <?= $mechanic['completion_rate'] ?>%"></div>
                                            </div>
                                            <span><?= number_format($mechanic['completion_rate'], 1) ?>%</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="revenue-info">
                                            <strong class="text-gold"><?= formatCurrency($mechanic['total_earned']) ?></strong>
                                            <?php if($mechanic['pending_commission'] > 0): ?>
                                            <small class="text-warning">
                                                <i class="bi bi-hourglass-split"></i>
                                                <?= formatCurrency($mechanic['pending_commission']) ?>
                                            </small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="performance-badge performance-<?= getPerformanceLevel($mechanic['performance_score']) ?>">
                                            <?= number_format($mechanic['performance_score'], 1) ?>%
                                        </div>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?= formatDate($mechanic['registration_date'], 'd/m/Y') ?></small>
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            <i class="bi bi-clock"></i>
                                            <?= timeAgo($mechanic['last_active']) ?>
                                        </small>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <button class="btn btn-sm btn-icon btn-primary" 
                                                    onclick="viewMechanic(<?= $mechanic['id'] ?>)" 
                                                    title="Voir détails">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-icon btn-success" 
                                                    onclick="editMechanic(<?= $mechanic['id'] ?>)" 
                                                    title="Modifier">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <div class="btn-group">
                                                <button class="btn btn-sm btn-icon btn-secondary dropdown-toggle" 
                                                        data-bs-toggle="dropdown">
                                                    <i class="bi bi-three-dots-vertical"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="viewLocation(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-map"></i> Localiser
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="viewDocuments(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-file-earmark-text"></i> Documents
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="viewPerformance(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-graph-up"></i> Performance
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="manageCommissions(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-currency-dollar"></i> Commissions
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <?php if($mechanic['status'] !== 'suspended'): ?>
                                                    <li>
                                                        <a class="dropdown-item text-warning" href="#" onclick="suspendMechanic(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-ban"></i> Suspendre
                                                        </a>
                                                    </li>
                                                    <?php else: ?>
                                                    <li>
                                                        <a class="dropdown-item text-success" href="#" onclick="activateMechanic(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-check-circle"></i> Activer
                                                        </a>
                                                    </li>
                                                    <?php endif; ?>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#" onclick="deleteMechanic(<?= $mechanic['id'] ?>)">
                                                            <i class="bi bi-trash"></i> Supprimer
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </main>
    
    <?php include __DIR__ . '/../../includes/footer.php'; ?>
</div>

<!-- Modal: View Mechanic Details -->
<div class="modal fade" id="viewMechanicModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-person-circle"></i>
                    Détails du Mécanicien
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="mechanicDetailsContent">
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Chargement...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Add Mechanic -->
<div class="modal fade" id="addMechanicModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-person-plus"></i>
                    Ajouter un Nouveau Mécanicien
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addMechanicForm">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <h6 class="mb-3"><i class="bi bi-person"></i> Informations personnelles</h6>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Nom complet *</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email *</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Téléphone *</label>
                            <input type="tel" class="form-control" name="phone" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Localisation *</label>
                            <input type="text" class="form-control" name="location" placeholder="Ville, Quartier" required>
                        </div>
                        
                        <div class="col-12 mt-4">
                            <h6 class="mb-3"><i class="bi bi-tools"></i> Compétences professionnelles</h6>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Spécialités *</label>
                            <select class="form-select" name="specialties[]" multiple size="5" required>
                                <option value="Batterie">Batterie</option>
                                <option value="Pneus">Pneus / Crevaison</option>
                                <option value="Panne sèche">Panne sèche</option>
                                <option value="Mécanique générale">Mécanique générale</option>
                                <option value="Diagnostic électronique">Diagnostic électronique</option>
                                <option value="Électricité">Électricité automobile</option>
                                <option value="Climatisation">Climatisation</option>
                                <option value="Transmission">Transmission</option>
                                <option value="Moteur">Réparation moteur</option>
                            </select>
                            <small class="form-text text-muted">Maintenez Ctrl/Cmd pour sélectionner plusieurs</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Zone de couverture</label>
                            <input type="text" class="form-control" name="coverage_zone" placeholder="Rayon en km">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Type de véhicule</label>
                            <select class="form-select" name="vehicle_type">
                                <option value="Moto">Moto</option>
                                <option value="Voiture">Voiture</option>
                                <option value="Camionnette">Camionnette</option>
                            </select>
                        </div>
                        
                        <div class="col-12 mt-4">
                            <h6 class="mb-3"><i class="bi bi-shield-check"></i> Vérification</h6>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Numéro CNI</label>
                            <input type="text" class="form-control" name="id_card_number">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Licence professionnelle</label>
                            <input type="text" class="form-control" name="professional_license">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-lg"></i>
                        Créer le mécanicien
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script src="<?= ASSETS_URL ?>js/main.js"></script>
<script src="<?= ASSETS_URL ?>js/mechanics.js"></script>

</body>
</html>

<?php
// Fonction helper pour badge de statut en ligne
function getOnlineStatusBadge($status) {
    $badges = [
        'online' => '<span class="badge bg-success"><i class="bi bi-circle-fill"></i> En ligne</span>',
        'offline' => '<span class="badge bg-secondary"><i class="bi bi-circle"></i> Hors ligne</span>',
        'busy' => '<span class="badge bg-warning"><i class="bi bi-hourglass-split"></i> Occupé</span>',
        'suspended' => '<span class="badge bg-danger"><i class="bi bi-ban"></i> Suspendu</span>',
    ];
    return $badges[$status] ?? '<span class="badge bg-secondary">Inconnu</span>';
}

// Fonction helper pour niveau de performance
function getPerformanceLevel($score) {
    if ($score >= 90) return 'excellent';
    if ($score >= 75) return 'good';
    if ($score >= 60) return 'average';
    return 'poor';
}
?>